import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define grid size
rows, cols = 6, 4

# Define colors for pieces
colors = {
    "rightl0": "blue",
    "rightl1": "green",
    "square0": "red",
    "square1": "yellow",
    "clear": "white"
}

# Create figure and axes
fig, ax = plt.subplots(figsize=(6, 9))
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.set_xticks([])
ax.set_yticks([])

# Draw grid cells
for row in range(rows):
    for col in range(cols):
        pos = f"f{row}-{col}f"
        if pos in ["f5-0f", "f5-1f", "f5-2f", "f5-3f", 
                   "f4-0f", "f4-1f", "f4-2f", "f4-3f",
                   "f3-2f", "f3-3f", "f2-1f", "f2-3f",
                   "f1-3f", "f0-1f", "f0-2f", "f0-3f"]:
            color = colors["clear"]
            status = "clear"
        else:
            color = "none"
            status = "occupied"
        
        rect = patches.Rectangle((col, rows - row - 1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows - row - 0.5, f"{pos}\n{status}", ha='center', va='center', fontsize=8, color='black')

# Draw pieces with bold outer edges
def draw_piece(positions, color, label):
    for col, row in positions:
        rect = patches.Rectangle((col, rows - row - 1), 1, 1, linewidth=3, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows - row - 0.3, label, ha='center', va='center', fontsize=8, color='white')

# rightl0
rightl0_positions = [(0, 3), (1, 3), (0, 2)]
draw_piece(rightl0_positions, colors["rightl0"], "rightl0")

# rightl1
rightl1_positions = [(0, 1), (1, 1), (0, 0)]
draw_piece(rightl1_positions, colors["rightl1"], "rightl1")

# square0
square0_position = (2, 1)
draw_piece([square0_position], colors["square0"], "square0")

# square1
square1_position = (2, 2)
draw_piece([square1_position], colors["square1"], "square1")

# Add legend
handles = [patches.Patch(color=colors[key], label=key) for key in ["rightl0", "rightl1", "square0", "square1", "clear"]]
ax.legend(handles=handles, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save figure
plt.savefig("tetris/one_shot/ini_diagram_code/attempts/attempt_9.png", bbox_inches='tight')
plt.show()